/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.uddi;

import filenet.vw.base.VWDebug;
import filenet.vw.base.VWUDDIBusinessEntity;
import filenet.vw.base.VWUDDIRegistry;
import filenet.vw.base.VWUDDIRegistryList;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.table.AbstractTableModel;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.Name;

public class VWConfigBusinessPublishInfoTableModel
extends AbstractTableModel {
    public static final int COLUMN_COUNT = 6;
    public static final int COLUMN_BUSINESS_NAME = 0;
    public static final int COLUMN_UDDI_REGISTRY = 1;
    public static final int COLUMN_PUBLISH = 2;
    public static final int COLUMN_BUSINESS_DESCRIPTION = 3;
    public static final int COLUMN_USERNAME = 4;
    public static final int COLUMN_BUSINESS_KEY = 5;
    protected String[] m_columnNames = new String[]{VWResource.BusinessName, VWResource.UDDIRegistry, " ", VWResource.BusinessDescription, VWResource.User, VWResource.BusinessKey};
    protected JDialog m_parentDialog = null;
    protected String m_dialogTitle = null;
    private Vector m_rowData = null;
    private boolean m_bHasChanged = false;
    private VWUDDIRegistryList m_uddiRegistryList = null;
    private VWUDDIRegistry[] m_uddiRegistries = null;

    public VWConfigBusinessPublishInfoTableModel(JDialog parentDialog, VWUDDIRegistryList uddiRegistryList) {
        try {
            this.m_parentDialog = parentDialog;
            this.m_rowData = new Vector();
            this.m_uddiRegistryList = uddiRegistryList;
            this.m_uddiRegistries = this.m_uddiRegistryList.getUDDIRegistries();
            if (this.m_uddiRegistries != null) {
                Vector uddiList = new Vector();
                for (int i = 0; i < this.m_uddiRegistries.length; ++i) {
                    VWUDDIBusinessEntity[] vwBusinessEntities;
                    if (this.m_uddiRegistries[i].getPublishURL() == null || (vwBusinessEntities = this.m_uddiRegistries[i].getVWBusinessEntities()) == null) continue;
                    int length = vwBusinessEntities.length;
                    for (int j = 0; j < length; ++j) {
                        this.m_rowData.add(vwBusinessEntities[j]);
                    }
                }
            }
            this.m_dialogTitle = VWIDMBaseFactory.instance().getVWString(4).toString();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWUDDIBusinessEntity[] getVWBusinessEntities() {
        Object[] theList = new VWUDDIBusinessEntity[this.m_rowData.size()];
        this.m_rowData.copyInto(theList);
        return theList;
    }

    public Vector getVWBusinessEntitityVector() {
        return this.m_rowData;
    }

    public void addRow() {
        try {
            if (this.m_rowData == null) {
                this.m_rowData = new Vector();
            }
            this.m_rowData.addElement(new VWUDDIBusinessEntity());
            int nRow = this.m_rowData.size() - 1;
            this.fireTableRowsInserted(nRow, nRow);
            this.m_bHasChanged = true;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void removeRow(int nRow) {
        try {
            if (this.m_rowData == null || nRow < 0 || nRow >= this.m_rowData.size()) {
                return;
            }
            VWUDDIBusinessEntity rowItem = (VWUDDIBusinessEntity)this.m_rowData.elementAt(nRow);
            if (rowItem != null) {
                this.m_rowData.removeElementAt(nRow);
                this.fireTableRowsDeleted(nRow, nRow);
                this.m_bHasChanged = true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean validateRow(int nRow) {
        try {
            if (this.m_rowData == null) {
                return true;
            }
            String msg = null;
            VWUDDIBusinessEntity rowItem = (VWUDDIBusinessEntity)this.m_rowData.elementAt(nRow);
            if (rowItem != null) {
                String businessName = rowItem.getNameString(0);
                if (businessName == null || businessName.length() < 1) {
                    msg = VWResource.InvalidUDDIBusinessEntity.toString(businessName, String.valueOf(nRow + 1), String.valueOf(nRow + 1));
                    return false;
                }
                String uddiName = rowItem.getUDDIRegistry();
                if (uddiName == null || uddiName.length() < 1) {
                    msg = VWResource.InvalidUDDIRegistry.toString(uddiName, String.valueOf(nRow + 1), String.valueOf(nRow + 1));
                    return false;
                }
                msg = this.checkDuplicateName(businessName, rowItem.getUDDIRegistry(), nRow);
                if (msg != null && msg.length() > 0) {
                    VWMessageDialog.showOptionDialog(this.m_parentDialog, msg, this.m_dialogTitle, 1);
                    return false;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return true;
    }

    public boolean hasChanged() {
        return this.m_bHasChanged;
    }

    public boolean verifyBusinessEntities() {
        boolean bSuccess;
        block3: {
            bSuccess = true;
            try {
                if (this.m_rowData == null) break block3;
                int rowCount = this.m_rowData.size();
                for (int i = 0; i < rowCount; ++i) {
                    if (this.validateRow(i)) continue;
                    bSuccess = false;
                    break;
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                bSuccess = false;
            }
        }
        return bSuccess;
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: 
            case 3: 
            case 4: 
            case 5: {
                return String.class;
            }
            case 2: {
                return Boolean.class;
            }
            case 1: {
                return JComboBox.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return this.m_columnNames.length;
    }

    public String getColumnName(int nColumn) {
        if (nColumn < 0 || nColumn >= this.m_columnNames.length) {
            return null;
        }
        return this.m_columnNames[nColumn];
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size();
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            if (this.m_rowData == null) {
                return null;
            }
            VWUDDIBusinessEntity businessEntity = (VWUDDIBusinessEntity)this.m_rowData.elementAt(nRowIndex);
            if (businessEntity == null) {
                return null;
            }
            switch (nColumnIndex) {
                case 0: {
                    String businessName = businessEntity.getNameString(0);
                    if (businessName == null) {
                        businessName = "";
                    }
                    return businessName;
                }
                case 1: {
                    String uddiRegistry = businessEntity.getUDDIRegistry();
                    if (uddiRegistry == null) {
                        uddiRegistry = "";
                    }
                    return uddiRegistry;
                }
                case 2: {
                    return new Boolean(businessEntity.getPublish());
                }
                case 3: {
                    String businessDesc = businessEntity.getDescriptionString(0);
                    if (businessDesc == null) {
                        businessDesc = "";
                    }
                    return businessDesc;
                }
                case 4: {
                    String user = businessEntity.getAuthorizedName();
                    if (user == null) {
                        user = "";
                    }
                    return user;
                }
                case 5: {
                    String businessKey = businessEntity.getBusinessKey();
                    if (businessKey == null) {
                        businessKey = "";
                    }
                    return businessKey;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRow, int nColumn) {
        return true;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        try {
            if (this.m_rowData == null) {
                return;
            }
            VWUDDIBusinessEntity businessEntity = (VWUDDIBusinessEntity)this.m_rowData.elementAt(nRowIndex);
            if (businessEntity == null) {
                return;
            }
            Vector<Object> v = null;
            switch (nColumnIndex) {
                case 0: {
                    v = new Vector<Object>();
                    v.add(new Name((String)aValue));
                    businessEntity.setNameVector(v);
                    this.m_bHasChanged = true;
                    break;
                }
                case 1: {
                    businessEntity.setUDDIRegistry((String)aValue);
                    this.m_bHasChanged = true;
                    break;
                }
                case 2: {
                    Boolean bPublish = (Boolean)aValue;
                    businessEntity.setPublish(bPublish);
                    this.m_bHasChanged = true;
                    break;
                }
                case 3: {
                    v = new Vector();
                    v.add(new Description((String)aValue));
                    businessEntity.setDescriptionVector(v);
                    this.m_bHasChanged = true;
                    break;
                }
                case 4: {
                    businessEntity.setAuthorizedName((String)aValue);
                    this.m_bHasChanged = true;
                    break;
                }
                case 5: {
                    businessEntity.setBusinessKey((String)aValue);
                    this.m_bHasChanged = true;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseResources() {
        this.m_parentDialog = null;
        this.m_dialogTitle = null;
    }

    private String checkDuplicateName(String businessName, String uddiName, int row) {
        String msg = null;
        if (businessName == null || businessName.trim().length() < 1) {
            msg = VWResource.s_missingBusinessNameInRow.toString(String.valueOf(row + 1));
            return msg;
        }
        int rowCount = this.m_rowData.size();
        for (int i = 0; i < rowCount; ++i) {
            if (i == row) continue;
            VWUDDIBusinessEntity vwBusiness = (VWUDDIBusinessEntity)this.m_rowData.elementAt(i);
            String bName = vwBusiness.getNameString(0);
            if (bName == null || bName.length() < 1) {
                msg = VWResource.s_missingBusinessNameInRow.toString(String.valueOf(i + 1));
                break;
            }
            if (businessName.compareTo(bName) != 0) continue;
            String un = vwBusiness.getUDDIRegistry();
            if (un == null || un.length() < 1) {
                msg = VWResource.InvalidUDDIRegistry.toString(bName, String.valueOf(i + 1), String.valueOf(row + 1));
                break;
            }
            if (uddiName.compareTo(un) != 0) continue;
            msg = VWResource.DuplicatedBusinessInfo.toString(bName, String.valueOf(i + 1), String.valueOf(row + 1));
            break;
        }
        return msg;
    }
}

